import { Link, useLocation } from 'react-router-dom'
import { Box } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

function Layout({ children }) {
  const location = useLocation()

  return (
    <div className="app">
      <header className="header">
        <div className="container">
          <div className="header-content">
            <Link to="/" className="logo">
              <div className="logo-icon-wrapper">
                <Box size={32} strokeWidth={2.5} className="logo-icon" />
                <div className="logo-glow"></div>
              </div>
              <span className="logo-text">Model3D</span>
            </Link>
            <nav className="nav">
              <Link 
                to="/" 
                className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои проекты
              </Link>
              <Link 
                to="/enroll" 
                className={`nav-link ${location.pathname === '/enroll' ? 'active' : ''}`}
              >
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main-content">
        {children}
      </main>

      <Footer />
    </div>
  )
}

export default Layout

